# WebCron PHP (Self-contained, no Composer)

**Upload lên cPanel là chạy.** Không cần `composer install`. Đã có:
- Cron parser tối giản (app/Cron.php)
- Proxy global + per-job, verify SSL
- UI đẹp (Bootstrap 5 + Tabler), Dark theme
- SQLite auto-migrate
- Cron runner mỗi phút

## Deploy nhanh (cPanel)
1. Tải file ZIP lên, giải nén vào thư mục (ví dụ `/home/USER/webcron-php/`).
2. Trỏ **Document Root** của domain/subdomain vào `webcron-php/public/`.
3. Bảo đảm PHP ≥ 8.1 và bật `curl`, `pdo_sqlite`.
4. Tạo DB (tùy chọn): nếu host có sqlite3, chạy:
   ```bash
   sqlite3 storage/cron.db < storage/schema.sql
   ```
   Không có cũng không sao: app sẽ tự migrate.
5. Tạo **Cron Job** mỗi phút:
   ```bash
   * * * * * /usr/bin/php /home/USER/webcron-php/bin/runner.php > /dev/null 2>&1
   ```
   (Sửa đường dẫn PHP và HOME cho đúng host)

## Proxy
- Cấu hình global: sửa `app/config.php`, hoặc đặt ENV `WEBCRON_GLOBAL_PROXY` trong cPanel.
- Per-job: nhập `Proxy URL`, `Proxy Auth` và tick/bỏ `Verify SSL` trực tiếp trên form.

## Ghi chú
- Cron parser hỗ trợ: `*`, `*/n`, `a-b`, `a,b,c`, `a-b/n` cho 5 field (phút giờ ngày-tháng tháng thứ-trong-tuần).
- Nếu muốn chuyển sang thư viện chuẩn sau này, chỉ cần thay `app/Cron.php` bằng lib bạn thích và sửa `require`.
