<?php
// app/db.php
declare(strict_types=1);

$dsn = 'sqlite:' . __DIR__ . '/../storage/cron.db';
$pdo = new PDO($dsn, null, null, [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
]);

// Auto-migrate base schema
$schema = file_get_contents(__DIR__ . '/../storage/schema.sql');
$pdo->exec($schema);

// Ensure ALTERs exist (ignore errors if already applied)
$alters = [
  "ALTER TABLE jobs ADD COLUMN proxy_url TEXT DEFAULT NULL",
  "ALTER TABLE jobs ADD COLUMN proxy_auth TEXT DEFAULT NULL",
  "ALTER TABLE jobs ADD COLUMN verify_ssl INTEGER NOT NULL DEFAULT 1"
];
foreach ($alters as $sql) {
  try { $pdo->exec($sql); } catch (Throwable $e) { /* ignore if exists */ }
}
