<?php
// app/helpers.php
declare(strict_types=1);

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function json_or_null($s): ?array {
  if ($s === null) return null;
  if (is_array($s)) return $s;
  if (trim((string)$s) === '') return null;
  $d = json_decode((string)$s, true);
  return is_array($d) ? $d : null;
}

function shorten(?string $s, int $limit = 500): ?string {
  if ($s === null) return null;
  return mb_strlen($s) > $limit ? mb_substr($s, 0, $limit) . '…' : $s;
}

function apply_proxy_and_ssl(array $job, $ch, array $config): void {
  $proxy = $job['proxy_url'] ?? null;
  if (!$proxy && !empty($config['global_proxy'])) $proxy = $config['global_proxy'];
  if ($proxy) {
    curl_setopt($ch, CURLOPT_PROXY, $proxy);
    if (!empty($job['proxy_auth'])) {
      curl_setopt($ch, CURLOPT_PROXYUSERPWD, $job['proxy_auth']);
    }
  }
  $verify = isset($job['verify_ssl']) ? (bool)$job['verify_ssl'] : (bool)($config['ssl_verify'] ?? true);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $verify);
  curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, $verify ? 2 : 0);
  // (Optional) force HTTP/1.1 to avoid quirky HTTP/2 issues on some shared hosts
  if (!empty($config['force_http1'])) {
    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
  }
}
