-- storage/schema.sql
CREATE TABLE IF NOT EXISTS jobs (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  name TEXT NOT NULL,
  url TEXT NOT NULL,
  method TEXT NOT NULL DEFAULT 'GET',
  headers TEXT DEFAULT NULL,
  body TEXT DEFAULT NULL,
  cron_expr TEXT NOT NULL,
  enabled INTEGER NOT NULL DEFAULT 1,
  timeout_sec INTEGER NOT NULL DEFAULT 30,
  created_at TEXT NOT NULL DEFAULT (datetime('now')),
  updated_at TEXT NOT NULL DEFAULT (datetime('now')),
  last_run_at TEXT DEFAULT NULL,
  last_status TEXT DEFAULT NULL,
  last_http_code INTEGER DEFAULT NULL,
  last_error TEXT DEFAULT NULL,

  proxy_url TEXT DEFAULT NULL,
  proxy_auth TEXT DEFAULT NULL,
  verify_ssl INTEGER NOT NULL DEFAULT 1
);

CREATE TABLE IF NOT EXISTS job_logs (
  id INTEGER PRIMARY KEY AUTOINCREMENT,
  job_id INTEGER NOT NULL,
  started_at TEXT NOT NULL,
  finished_at TEXT,
  success INTEGER NOT NULL,
  http_code INTEGER,
  duration_ms INTEGER,
  response_preview TEXT,
  error TEXT,
  FOREIGN KEY(job_id) REFERENCES jobs(id) ON DELETE CASCADE
);

CREATE INDEX IF NOT EXISTS idx_job_logs_job_id ON job_logs(job_id);
